package gov.va.med.mhv.usermgmt.web.controller;

import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.usermgmt.common.dto.ActivityDTO;
import gov.va.med.mhv.usermgmt.common.dto.ActivitySearchCriteriaDTO;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActorTypeEnumeration;
import gov.va.med.mhv.usermgmt.service.AccountActivityLogService;
import gov.va.med.mhv.usermgmt.web.util.WebUtility;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.ManagedBean;
import javax.annotation.Resource;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.event.data.SortEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.portal.model.User;
import com.liferay.portal.util.PortalUtil;

@ManagedBean
@Component
@Scope("session")
public class AccountActivityController  extends AbstractController{
	
	private static final long serialVersionUID = -1947472689045056321L;
	private static final Logger LOG = LogManager.getLogger(AccountActivityController.class);
	
	private ActivitySearchCriteriaDTO searchActivityCriteria = new ActivitySearchCriteriaDTO();
	private ActivityDTO selectedActivity = new ActivityDTO();
	private List<ActivityDTO> activities;
	private String firstName;
	private String lastName;
	private String tillDate;
	private DataTable activitySummaryTable;
	private String minimumDate;
	private String maximumDate;
	private static final String MMDDYYYY_FORMAT="MM/dd/yyyy";
	private static final String USERPROFILE_DTO_KEY = "LIFERAY_SHARED_userprofiledto";
	
	@Resource(name = "accountActivityProxy")
	private AccountActivityLogService accountActivityService;
	
	@Autowired
	private ObjectMapper mapper;
	
	public void init(ComponentSystemEvent event){
		FacesContext context =FacesContext.getCurrentInstance();
		setCalendarDisplayDates();
		activitySummaryTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("accountActivity:actvtList");
		if(!context.isPostback()){
			setRowsPerPage(10);
			Calendar cal =Calendar.getInstance();
			searchActivityCriteria.setToDate(cal.getTime());
			cal.add(Calendar.YEAR, -1);
			searchActivityCriteria.setFromDate(cal.getTime());
			tillDate=WebUtility.dateToString(cal.getTime(), "MMM dd, yyyy");
			searchActivityCriteria.setPerformerType(ActivityActorTypeEnumeration.EVERYONE.getDescription());
			PortletRequest   request = (PortletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
			User user=null;
			UserProfileDTO userProfile = null;
			
	        try {
	        	user = PortalUtil.getUser(request);
	        	userProfile = getUserProfileDTOFromSession();
	        	//searchActivityCriteria.setUserName(user.getScreenName());
	        	searchActivityCriteria.setUserName(userProfile.getUserName());
	    		this.activities = findActivities(searchActivityCriteria);
	        } 
	        catch (Exception e) {
	        	LOG.error(e);
	        	FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Error Processing request", "Error initializing account activity data view."));
			}
	        
	        /*
	        if(user != null){
	        	firstName=user.getFirstName();
	        	lastName=user.getLastName();
	        }*/
	        
	        if(userProfile != null){
	        	firstName=userProfile.getName().getFirstName();
	        	lastName=userProfile.getName().getLastName();
	        }
	        
			if(!FacesContext.getCurrentInstance().isPostback()){
				setRowsPerPage(10);
			}
		} else {
			if(sortColumn != null && sortBy != null){
				activitySummaryTable.setValueExpression("sortBy", sortColumn);
				activitySummaryTable.setSortOrder(sortBy);
			} 
		}
	}
	
	protected UserProfileDTO getUserProfileDTOFromSession() throws MHVException {
		UserProfileDTO userProfile;
		PortletSession session = null;
		try {
			PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext()
					.getRequest();
			session = request.getPortletSession();

			String patientStr = (String) session.getAttribute(USERPROFILE_DTO_KEY, PortletSession.APPLICATION_SCOPE);
			userProfile = mapper.readValue(patientStr, UserProfileDTO.class);

		} catch (Exception e) {
			throw new MHVException("Unable to get UserProfileDTO from session");
		}
		return userProfile;
	}

	public String accountSummaryPrint() {
		resetMessages();
		activitySummaryTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("accountActivity:actvtList");
		return "accountSummaryPrint";
	}
	
	private void setCalendarDisplayDates() {
		Calendar calendar= Calendar.getInstance();
		int year =calendar.get(Calendar.YEAR);
		calendar.set(year,11,31,0,0,0);
		maximumDate =WebUtility.dateToString(calendar.getTime(), MMDDYYYY_FORMAT);
		calendar.set(year-1,0,01,0,0,0);
		minimumDate=WebUtility.dateToString(calendar.getTime(), MMDDYYYY_FORMAT);
	}


	private List<ActivityDTO> findActivities(ActivitySearchCriteriaDTO searchActivityCriteria) {
		List<ActivityDTO> dtoList = null;
		try {
			updateSearchDatesWithTime(searchActivityCriteria);
			dtoList = this.accountActivityService.getAccountActvity(searchActivityCriteria);

			int correctedCount = correctSortOrder(dtoList);
			if(LOG.isDebugEnabled()) { LOG.debug("Corrected " + correctedCount + " records sort order."); }
			
		} catch(MHVException e){
        	LOG.error("Error in findActivities", e);
        	super.processErrorMessages(e);
        } catch (Exception e) {
        	LOG.error("Error in Find Activities:", e);
        	FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Error Processing request", "Error initializing account activity data view."));
		}
		
		return dtoList;
	}

	private int correctSortOrder(List<ActivityDTO> dtoList) {
		int count = 0;
		
		//ADD SEQUENCIAL MILLISECOND IF TWO RECORDS HAVE EXACT TIMES TO SECONDS
		Map<Date,List<Long>> dateMap = new HashMap<Date,List<Long>>();
		
		//ADD UNSORTED ID'S
		for( ActivityDTO a: dtoList ) {
			Date d = a.getCompletionTime();
			if( !dateMap.containsKey(d) ) {
				dateMap.put(d, new ArrayList<Long>());
			}
			dateMap.get(d).add(a.getActivityId());
		}
		
		//REMOVE THE DATE KEY IF THERE IS ONLY ONE IN THE SAME MINUTE
		List<Date> dates = new ArrayList<Date>();
		for( Date d: dateMap.keySet() ){ dates.add(d); }

		for( Date d: dates) {
			if( dateMap.get(d).size() > 1 ) {
				Collections.sort(dateMap.get(d));
			} else {
				dateMap.remove(d);
			}
		}

		//IF THERE ARE DUPLICATE RECORDS BASED ON DATE/TIME DOWN TO THE SECOND THEN ASSIGN MILLISECOND IN ORDER BASED ON SEQ ID
		Calendar c = Calendar.getInstance();
		for( ActivityDTO a: dtoList ) {
			if( dateMap.containsKey(a.getCompletionTime()) ) {
				int idx = dateMap.get(a.getCompletionTime()).indexOf(a.getActivityId());
				c.setTime(a.getCompletionTime());
				c.set(Calendar.MILLISECOND, idx);
				a.setCompletionTime(c.getTime());
				count++;
			}
		}
		
		return count;
	}

	private void updateSearchDatesWithTime(ActivitySearchCriteriaDTO searchActivityCriteria) {
		Date to_Date=searchActivityCriteria.getToDate();
		if(to_Date != null){
			Calendar calendar= Calendar.getInstance();
			calendar.setTime(to_Date);
			int year =calendar.get(Calendar.YEAR);
			int month=calendar.get(Calendar.MONTH);
			int date=calendar.get(Calendar.DATE);
			calendar.set(year,month,date,23,59,59);
			searchActivityCriteria.setToDate(calendar.getTime());
		}
	}

	public void searchActivities(){
		setRowsPerPage(10);
		activities=findActivities(searchActivityCriteria);
	}
	
	public String showDetail(ActivityDTO activityDTO){
		selectedActivity= activityDTO;
		return "accountActivityDetail";
	}
	
	public ActivityDTO getSelectedActivity() {
		return selectedActivity;
	}

	public void setSelectedActivity(ActivityDTO selectedActivity) {
		this.selectedActivity = selectedActivity;
	}
	
	public ActivitySearchCriteriaDTO getSearchActivityCriteria() {
		return searchActivityCriteria;
	}

	public void setSearchActivityCriteria(
			ActivitySearchCriteriaDTO searchActivityCriteria) {
		this.searchActivityCriteria = searchActivityCriteria;
	}

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getTillDate() {
		return tillDate;
	}

	public void setTillDate(String tillDate) {
		this.tillDate = tillDate;
	}

	public DataTable getActivitySummaryTable() {
		return activitySummaryTable;
	}

	public void setActivitySummaryTable(DataTable activitySummaryTable) {
		this.activitySummaryTable = activitySummaryTable;
	}

	public String getMinimumDate() {
		return minimumDate;
	}

	public void setMinimumDate(String minimumDate) {
		this.minimumDate = minimumDate;
	}

	public String getMaximumDate() {
		return maximumDate;
	}

	public void setMaximumDate(String maximumDate) {
		this.maximumDate = maximumDate;
	}
	
	public int getPages() {
		return this.activitySummaryTable.getPageCount();
	}
	
	public List<ActivityDTO> getActivities() {
		return activities;
	}
	
    public void onSort(SortEvent event){
        activitySummaryTable.setSortBy(event.getSortColumn().getValueExpression("sortBy"));
        activitySummaryTable.setSortOrder(event.isAscending()?"ascending":"descending");
    }
    
}
